/*-----------------------------------------------------------------------------
 * EcOs.h                   
 * Copyright                acontis technologies GmbH, Weingarten, Germany
 * Response                 Stefan Zintgraf
 * Description              AT-EM OS-Layer header
 *---------------------------------------------------------------------------*/

#ifndef INC_ECOS
#define INC_ECOS

/*-INCLUDES------------------------------------------------------------------*/
#ifndef INC_ECTYPE
#include "EcType.h"
#endif
#include <EcOsPlatform.h>

/*-PACK SETTINGS-------------------------------------------------------------*/
#if defined  __GNUC__   /* GNU */

#define EC_PACKED __attribute__((aligned(4), packed))

#if (defined __RCX__)
#pragma pack (4)
#endif

#elif defined _DIAB_TOOL

#define EC_PACKED __attribute__((aligned(4), packed))

#elif defined _MSC_VER  /* MICROSOFT */

#define EC_PACKED
#pragma pack (push, 4)
#pragma warning(disable:4514)

#elif defined __MET__

#define EC_PACKED
/*#pragma pack (push, 4)*/
#pragma Push_align_members(4)

#else
#error Please check pack settings for this compiler!!!
#endif

/*-TYPEDEFS------------------------------------------------------------------*/
typedef EC_T_VOID (*EC_PF_OSTIMER)(EC_T_VOID);
typedef EC_T_BOOL (*EC_PF_OSDBGMSGHK)(const EC_T_CHAR* szFormat, EC_T_VALIST vaArgs);
typedef EC_T_VOID (*EC_PF_THREADENTRY)(EC_T_VOID* pvParams);
typedef EC_T_VOID (*EC_PF_LLREGISTER)(EC_T_VOID);

/* SMP support */
#ifndef EC_CPUSET_DEFINED
typedef unsigned long   EC_T_CPUSET;        /* CPU-set for SMP systems */
#endif

typedef EC_T_DWORD (*EC_PF_SYSTIME)(EC_T_UINT64* pqwSystemTime);

typedef struct _EC_T_OS_INIT_DESC
{
    EC_T_DWORD      dwTimerPriority;
    EC_PF_SYSTIME   pfSystemTimeGet;
    EC_T_PVOID      pvPlatformSpecific;
} EC_PACKED EC_T_OS_INIT_DESC;

/*-MACROS--------------------------------------------------------------------*/
#define     EC_OFFSETOF(s,m)    ((size_t)&(((s *)0)->m))

#define     EC_INTSIZEOF(n)     ( (sizeof(n) + sizeof(int) - 1) & ~(sizeof(int) - 1) )
#ifndef EC_VASTART
#define     EC_VASTART(ap,v)    ( ap = (EC_T_VALIST)&v + EC_INTSIZEOF(v) )
#endif
#ifndef EC_VAARG
#define     EC_VAARG(ap,t)      ( *(t *)((ap += EC_INTSIZEOF(t)) - EC_INTSIZEOF(t)) )
#endif
#ifndef EC_VAEND
#define     EC_VAEND(ap)        ( ap = (EC_T_VALIST)0 )
#endif

#define     EC_UNREFPARM(p)     {(p)=(p);}
#define     EC_MAX(a,b)         (((a) > (b)) ? (a) : (b))
#define     EC_MIN(a,b)         (((a) < (b)) ? (a) : (b))
#define     EC_ENDOF(p)         ((p)+1)

#define     SafeDelete(p)       {if (EC_NULL!=(p)) {delete    (p); (p) = EC_NULL;}}
#define     SafeDeleteArray(p)  {if (EC_NULL!=(p)) {delete [] (p); (p) = EC_NULL;}}

/* SMP support */
#ifndef EC_CPUSET_DEFINED
/* This macros will be overloaded by the specific EcOsPlatform.h */
#define     EC_CPUSET_ZERO(CpuSet)          (CpuSet) = 0    /* clear all CPU indexes in the CPU set */
#define     EC_CPUSET_SET(CpuSet,nCpuIndex) (CpuSet) = 1    /* set CPU index nCpuIndex (0..x) in the CPU set */
#define     EC_CPUSET_SETALL(CpuSet)        (CpuSet) = 1    /* set all CPU indexes in the CPU set */
#endif

#define EC_BIT_MASK(Bitsize)                            ((1<<(Bitsize))-1)
#define EC_BITFIELD_MASK(Bitpos,Bitsize)                ((EC_BIT_MASK((Bitsize)))<<(Bitpos))
#define EC_RESET_WORD_IN_BITFIELD(wVal,Bitpos,Bitsize)  ((wVal)&(~EC_BITFIELD_MASK((Bitpos),(Bitsize))))
#define EC_SET_WORD_IN_BITFIELD(Bitpos,Bitsize,wVal)    (((wVal)&(EC_BIT_MASK((Bitsize))))<<(Bitpos))
#define EC_GET_WORD_IN_BITFIELD(Bitpos,Bitsize,wVal)    (((wVal)>>(Bitpos))&EC_BIT_MASK((Bitsize)))
                                                        

#define EC_BYTE0(x)     (((x) >>  0) & 0xff)
#define EC_BYTE1(x)     (((x) >>  8) & 0xff)
#define EC_BYTE2(x)     (((x) >> 16) & 0xff)
#define EC_BYTE3(x)     (((x) >> 24) & 0xff)
#define EC_BYTE4(x)     (((x) >> 32) & 0xff)
#define EC_BYTE5(x)    (((x) >> 40) & 0xff)
#define EC_BYTE6(x)     (((x) >> 48) & 0xff)
#define EC_BYTE7(x)     (((x) >> 56) & 0xff)

#define EC_WORD0(x)     (((x) >>  0) & 0xffff)
#define EC_WORD1(x)     (((x) >> 16) & 0xffff)

#define EC_WORDSWAP(x)  (EC_T_WORD)            \
                        ((EC_BYTE0((x)) <<  8) | \
                         (EC_BYTE1((x)) <<  0)   \
                        )
#define EC_DWORDSWAP(x) (EC_T_DWORD)           \
                        ((EC_BYTE0((x)) << 24) | \
                         (EC_BYTE1((x)) << 16) | \
                         (EC_BYTE2((x)) <<  8) | \
                         (EC_BYTE3((x)) <<  0)   \
                        )
#define EC_QWORDSWAP(x) (EC_T_UINT64)          \
                        ((EC_BYTE0((x)) << 56) | \
                         (EC_BYTE1((x)) << 48) | \
                         (EC_BYTE2((x)) << 40) | \
                         (EC_BYTE3((x)) << 32) | \
                         (EC_BYTE4((x)) << 24) | \
                         (EC_BYTE5((x)) << 16) | \
                         (EC_BYTE6((x)) <<  8) | \
                         (EC_BYTE7((x)) <<  0)   \
                        )

#ifdef EC_BIG_ENDIAN

#define EC_NO_BITFIELDS     /* big endian: do not use bitfields! */

#define EC_NTOHS(w)         EC_WORDSWAP((w))
#define EC_NTOHL(dw)        EC_DWORDSWAP((dw))
#define EC_NTOHLL(qw)       EC_QWORDSWAP((qw))

#define EC_HTONS(w)         EC_WORDSWAP((w))
#define EC_HTONL(dw)        EC_DWORDSWAP((dw))
#define EC_HTONLL(qw)       EC_QWORDSWAP((qw))

#define EC_GET_FRM_WORD_BITFIELD(wVal,Bitpos,Bitsize)           EC_GET_WORD_IN_BITFIELD((Bitpos),(Bitsize),EC_WORDSWAP((wVal)))
#define EC_SET_FRM_WORD_BITFIELD(wVal,wNewVal,Bitpos,Bitsize)   (wVal) = ((wVal) & ~EC_WORDSWAP(EC_BITFIELD_MASK((Bitpos),(Bitsize)))) | (EC_WORDSWAP((wNewVal)<<(Bitpos)));

#else /* #ifdef EC_BIG_ENDIAN */

#define EC_NTOHS(w)          (w)
#define EC_NTOHL(dw)        (dw)
#define EC_NTOHLL(qw)       (qw)

#define EC_HTONS(w)          (w)
#define EC_HTONL(dw)        (dw)
#define EC_HTONLL(qw)       (qw)


#define EC_GET_FRM_WORD_BITFIELD(Bitpos,Bitsize,wVal)           EC_GET_WORD_IN_BITFIELD((Bitpos),(Bitsize),(wVal))
#define EC_SET_FRM_WORD_BITFIELD(wVal,wNewVal,Bitpos,Bitsize)   (wVal) = ((wVal) & ~EC_BITFIELD_MASK((Bitpos),(Bitsize))) | ((wNewVal)<<(Bitpos));

#endif

#define EC_GET_FRM_WORD(ptr)        EC_NTOHS(EC_GETWORD((ptr)))
#define EC_GET_FRM_DWORD(ptr)       EC_NTOHL(EC_GETDWORD((ptr)))
#define EC_GET_FRM_QWORD(ptr)       EC_NTOHLL(EC_GETQWORD((ptr)))

#define EC_SET_FRM_WORD(ptr,  w)      EC_SETWORD(ptr,  EC_HTONS((w)))
#define EC_SET_FRM_DWORD(ptr, dw)     EC_SETDWORD(ptr, EC_HTONL((dw)))
#define EC_SET_FRM_QWORD(ptr, qw)     EC_SETQWORD(ptr, EC_HTONLL((qw)))


/*-MACROS--------------------------------------------------------------------*/


/*-FUNCTION DECLARATION------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif

#if defined QNX6 || defined __RCX__
EC_T_DWORD OsSetLastError(EC_T_DWORD dwError);
#endif

ATECAT_API EC_T_DWORD  OsInit(EC_T_OS_INIT_DESC* pOsParms);
ATECAT_API EC_T_DWORD  OsDeinit(EC_T_VOID);
ATECAT_API EC_T_VOID   OsAddDbgMsgHook(EC_PF_OSDBGMSGHK pfOsDbgMsgHook);

#ifndef OsMalloc
ATECAT_API EC_T_VOID*  OsMalloc(size_t nSize);
#endif
#ifndef OsRealloc
EC_T_VOID*  OsRealloc(EC_T_VOID* pvMem, EC_T_INT nSize);
#endif
#ifndef OsFree
ATECAT_API EC_T_VOID   OsFree(EC_T_VOID* pvMem);
#endif

#ifndef OsMemset
EC_T_VOID*  OsMemset(EC_T_VOID* pvMem, EC_T_INT nVal, EC_T_INT nSize);
#endif
#ifndef OsMemcpy
EC_T_VOID*  OsMemcpy(EC_T_VOID* pvDst, const EC_T_VOID* pvSrc, EC_T_INT nSize);
#endif
#ifndef OsMemcmp
EC_T_INT    OsMemcmp(const EC_T_VOID* pvMem1, const EC_T_VOID* pvMem2, EC_T_INT nSize);
#endif
#ifndef OsMemmove
EC_T_VOID*  OsMemmove(EC_T_VOID* pvDst, const EC_T_VOID* pvSrc, EC_T_INT nSize);
#endif

#ifndef OsStrlen
EC_T_INT    OsStrlen(const EC_T_CHAR* szString);
#endif
#ifndef OsStrcpy
EC_T_CHAR*  OsStrcpy(EC_T_CHAR* szDst, const EC_T_CHAR* szSrc);
#endif
#ifndef OsStrncpy
EC_T_CHAR*  OsStrncpy(EC_T_CHAR* szDst, const EC_T_CHAR* szSrc, EC_T_INT nSize);
#endif
#ifndef OsStrcmp
EC_T_INT    OsStrcmp(const EC_T_CHAR* szString1, const EC_T_CHAR* szString2);
#endif
#ifndef OsStrtok
EC_T_CHAR*  OsStrtok(EC_T_CHAR* szString, const EC_T_CHAR* szToken);
#endif
#ifndef OsAtoi
EC_T_INT    OsAtoi(const EC_T_CHAR* strString);
#endif
#ifndef OsStrtoul
EC_T_INT    OsStrtoul(const EC_T_CHAR* strString, EC_T_CHAR** pstrPtr, EC_T_INT nBase);
#endif
#ifndef OsVsnprintf
EC_T_VOID   OsVsnprintf( EC_T_CHAR* szMsg, EC_T_INT nLen, const EC_T_CHAR* szFormat, EC_T_VALIST vaArgs );
#endif
#ifndef OsSnprintf
EC_T_VOID   OsSnprintf( EC_T_CHAR* szMsg, EC_T_INT nLen, const EC_T_CHAR* szFormat, ... );
#endif


#ifndef EC_NEW
#define EC_NEW(x) \
    new x
#endif


EC_T_VOID*  OsCfgFileOpen(const EC_T_CHAR* szCfgFileName);
EC_T_INT    OsCfgFileClose(EC_T_VOID* pvCfgFile);
EC_T_INT    OsCfgFileRead(EC_T_VOID* pvCfgFile, EC_T_VOID* pvDst, EC_T_INT nLen);
EC_T_INT    OsCfgFileError(EC_T_VOID* pvCfgFile);
EC_T_INT    OsCfgFileEof(EC_T_VOID* pvCfgFile);

/* these functions are actually part of the master core */
ATECAT_API EC_T_INT EcVsnprintf(EC_T_CHAR* szDest, EC_T_INT nMaxSize, const EC_T_CHAR* szFormat, EC_T_VALIST vaList);
ATECAT_API EC_T_INT EcSnprintf(EC_T_CHAR* szDest, EC_T_INT nMaxSize, const EC_T_CHAR* szFormat, ...);

#ifndef OsQueryMsecCount
ATECAT_API EC_T_DWORD  OsQueryMsecCount(EC_T_VOID);
#endif
#ifndef OsSleep
EC_T_VOID   OsSleep(EC_T_DWORD dwMsec);
#endif

ATECAT_API EC_T_VOID   OsDbgMsg(const EC_T_CHAR* szFormat, ...);

/***************************/
/* performance measurement */
/***************************/
/* timestamp counter interface for performance measurements (main functions are part of the master core) */
#ifndef INCLUDE_OS_PLATFORM_TSC_SUPPORT

/* if platform does not have specific TSC support, check for defaults if it is yet available */
#if (defined UNDER_CE && defined _M_IX86) || (defined RTOS_32) || (defined VXWORKS && defined CPU && ((CPU==PENTIUM) || (CPU==PENTIUM4))) || (defined QNX6) || ((defined WIN32) && !(defined UNDER_CE)) || (defined LINUX)
#define INCLUDE_OS_PLATFORM_TSC_SUPPORT
#define INCLUDE_PENTIUM_TSC
#endif
#if (defined __RCX__)
#define INCLUDE_OS_PLATFORM_TSC_SUPPORT
#define INCLUDE_ARM_TSC
#endif

#endif

typedef EC_T_VOID (*EC_T_FNMESSAGE) (EC_T_CHAR* szMsg);

#ifdef INCLUDE_OS_PLATFORM_TSC_SUPPORT

/* if platform does not support the timestamp counter interface, use dummy macros */
#define EcTscMeasInit(pTscMeasDesc,dwlFreqSet,dwNumMeas,pfnMessage)    EcTscMeasInit_(pTscMeasDesc,dwlFreqSet,dwNumMeas,pfnMessage)
#define EcTscMeasEnable(pTscMeasDesc)                       EcTscMeasEnable_(pTscMeasDesc)
#define EcTscMeasDisable(pTscMeasDesc)                      EcTscMeasDisable_(pTscMeasDesc)
#define EcTscMeasStart(pTscMeasDesc,dwIndex)                EcTscMeasStart_(pTscMeasDesc,dwIndex)
#define EcTscMeasEnd(pTscMeasDesc,dwIndex)                  EcTscMeasEnd_(pTscMeasDesc,dwIndex)
#define EcTscMeasShow(pTscMeasDesc,dwIndex,aszMeasInfo)     EcTscMeasShow_(pTscMeasDesc,dwIndex,aszMeasInfo)
#define EcTscMeasReset( pTscMeasDesc, dwIndex )             EcTscMeasReset_(pTscMeasDesc,dwIndex)
#define OsTscMeasCalibrate(dwlFreqSet)                      OsTscMeasCalibrate_(dwlFreqSet)
#define OsTscMeasGet100kHzFrequency()                       OsTscMeasGet100kHzFrequency_()
#define OsTscMeasGetCounterTicks()                          OsTscMeasGetCounterTicks_()

/* performance measurement descriptors */
typedef struct _EC_T_TSC_TIME
{
    EC_T_UINT64     qwStart;            /* start time */
    EC_T_UINT64     qwEnd;              /* end time */
    EC_T_DWORD      dwCurr;             /* [1/10 usec] */
    EC_T_DWORD      dwMax;              /* [1/10 usec] */
    EC_T_DWORD      dwAvg;              /* [1/100 usec] */
    EC_T_BOOL       bMeasReset;         /* EC_TRUE if measurement values shall be reset */
    EC_T_INT        nIntLevel;          /* for interrupt lockout handling */
} EC_PACKED EC_T_TSC_TIME;

typedef struct _EC_T_TSC_MEAS_DESC
{
    EC_T_TSC_TIME*  aTscTime;           /* timestamp info array */
    EC_T_DWORD      dwNumMeas;          /* number of elements in aTscTime */
    EC_T_BOOL       bMeasEnabled;       /* EC_TRUE if measurement is enabled */
    EC_T_VOID*      pPrivateData;       /* OS layer private data */
    EC_T_FNMESSAGE  pfnMessage;         /* Function pointer for message drop */
} EC_PACKED EC_T_TSC_MEAS_DESC;

#ifndef OsTscMeasDisableIrq
/* default macros to enable/disable interrupts */
#if (defined UNDER_CE) && (defined _M_IX86)
#define OsTscMeasDisableIrq(pTscMeasDesc,dwIndex)  { __asm  cli };
#define OsTscMeasEnableIrq(pTscMeasDesc,dwIndex)   { __asm  sti };
#elif (defined VXWORKS)
#include "intLib.h"
#ifdef _WRS_VX_SMP
#define OsTscMeasDisableIrq(pTscMeasDesc,dwIndex)  { pTscMeasDesc->aTscTime[dwIndex].nIntLevel = intCpuLock(); };
#define OsTscMeasEnableIrq(pTscMeasDesc,dwIndex)   { intCpuUnlock(pTscMeasDesc->aTscTime[dwIndex].nIntLevel); };
#else
#define OsTscMeasDisableIrq(pTscMeasDesc,dwIndex)  { pTscMeasDesc->aTscTime[dwIndex].nIntLevel = intLock(); };
#define OsTscMeasEnableIrq(pTscMeasDesc,dwIndex)   { intUnlock(pTscMeasDesc->aTscTime[dwIndex].nIntLevel); };
#endif
#elif (defined QNX6)
#define OsTscMeasDisableIrq(pTscMeasDesc,dwIndex)  { ThreadCtl( _NTO_TCTL_IO, 0 );InterruptDisable(); };
#define OsTscMeasEnableIrq(pTscMeasDesc,dwIndex)   { ThreadCtl( _NTO_TCTL_IO, 0 );InterruptEnable(); };
#elif (defined RTOS_32)
#define OsTscMeasDisableIrq(pTscMeasDesc,dwIndex)  { __asm  cli };
#define OsTscMeasEnableIrq(pTscMeasDesc,dwIndex)   { __asm  sti };
#else
#define OsTscMeasDisableIrq(pTscMeasDesc,dwIndex)
#define OsTscMeasEnableIrq(pTscMeasDesc,dwIndex)
#endif
#endif

#else  /* #ifdef INCLUDE_OS_PLATFORM_TSC_SUPPORT */

typedef struct  _EC_T_TSC_TIME
{
    EC_T_INT    nDummy;
} EC_PACKED EC_T_TSC_TIME;

typedef struct  _EC_T_TSC_MEAS_DESC
{
    EC_T_INT    nDummy;
} EC_PACKED EC_T_TSC_MEAS_DESC;

/* if platform does not support the timestamp counter interface, use dummy macros */
#define EcTscMeasInit(pTscMeasDesc,dwlFreqSet,dwNumMeas,pfnMessage)
#define EcTscMeasEnable(pTscMeasDesc)
#define EcTscMeasDisable(pTscMeasDesc)
#define EcTscMeasStart(pTscMeasDesc,dwIndex)
#define EcTscMeasEnd(pTscMeasDesc,dwIndex)
#define EcTscMeasShow(pTscMeasDesc,dwIndex,aszMeasInfo)
#define EcTscMeasReset(pTscMeasDesc,dwIndex)
#define OsTscMeasCalibrate(dwlFreqSet)
#define OsTscMeasGet100kHzFrequency()
#define OsTscMeasGetCounterTicks()

#endif /* #else INCLUDE_OS_PLATFORM_TSC_SUPPORT */

ATECAT_API EC_T_VOID EcTscMeasInit_( EC_T_TSC_MEAS_DESC* pTscMeasDesc, EC_T_UINT64 dwlFreqSet, EC_T_DWORD dwNumMeas, EC_T_FNMESSAGE pfnMessage);
ATECAT_API EC_T_VOID EcTscMeasDeinit_( EC_T_TSC_MEAS_DESC* pTscMeasDesc );
ATECAT_API EC_T_VOID EcTscMeasEnable_( EC_T_TSC_MEAS_DESC* pTscMeasDesc );
ATECAT_API EC_T_VOID EcTscMeasDisable_( EC_T_TSC_MEAS_DESC* pTscMeasDesc );
ATECAT_API EC_T_VOID EcTscMeasStart_( EC_T_TSC_MEAS_DESC* pTscMeasDesc, EC_T_DWORD dwIndex );
ATECAT_API EC_T_TSC_TIME* EcTscMeasEnd_( EC_T_TSC_MEAS_DESC* pTscMeasDesc, EC_T_DWORD dwIndex );
ATECAT_API EC_T_VOID EcTscMeasReset_( EC_T_TSC_MEAS_DESC* pTscMeasDesc, EC_T_DWORD dwIndex );
ATECAT_API EC_T_VOID EcTscMeasShow_( EC_T_TSC_MEAS_DESC* pTscMeasDesc, EC_T_DWORD dwIndex, EC_T_CHAR** aszMeasInfo );
ATECAT_API EC_T_VOID OsTscMeasCalibrate_(EC_T_UINT64 dwlFreqSet);
ATECAT_API EC_T_DWORD OsTscMeasGet100kHzFrequency_(EC_T_VOID);
ATECAT_API EC_T_UINT64 OsTscMeasGetCounterTicks_(EC_T_VOID);

/* optional: redirect trace messages into OS specific function, e.g. to store trace log into file 
 * default: print trace log as debug message
 */
#ifndef OsTrcMsg
#define     OsTrcMsg    OsDbgMsg
#endif
#ifndef OsDbgAssert
EC_T_VOID   OsDbgAssert(EC_T_BOOL bAssertCondition);
#endif

ATECAT_API EC_T_VOID*  OsCreateLock(EC_T_VOID);
ATECAT_API EC_T_VOID*  OsCreateLockTyped(EC_T_OS_LOCK_TYPE   eLockType);
ATECAT_API EC_T_VOID   OsDeleteLock(EC_T_VOID* pvLock);
ATECAT_API EC_T_VOID   OsLock(EC_T_VOID* pvLock);
ATECAT_API EC_T_VOID   OsUnlock(EC_T_VOID* pvLock);

ATECAT_API EC_T_VOID*  OsCreateEvent(EC_T_VOID);
ATECAT_API EC_T_VOID   OsDeleteEvent(EC_T_VOID* pvEvent);
#ifndef OsWaitForEvent
ATECAT_API EC_T_DWORD  OsWaitForEvent(EC_T_VOID* pvEvent, EC_T_DWORD dwTimeout);
#endif
#ifndef OsSetEvent
EC_T_VOID   OsSetEvent(EC_T_VOID* pvEvent);
#endif
/*
#ifndef OsResetEvent
EC_T_VOID   OsResetEvent(EC_T_VOID* pvEvent);
#endif
*/

ATECAT_API EC_T_VOID*  OsCreateThread(EC_T_CHAR* szThreadName, EC_PF_THREADENTRY pfThreadEntry, EC_T_DWORD dwPrio, EC_T_DWORD dwStackSize, EC_T_VOID* pvParams );
ATECAT_API EC_T_VOID   OsDeleteThreadHandle(EC_T_VOID* pvThreadObject);
ATECAT_API EC_T_VOID   OsSetThreadPriority( EC_T_VOID* pvThreadObject, EC_T_DWORD dwPrio );
ATECAT_API EC_T_BOOL   OsSetThreadAffinity( EC_T_VOID* pvThreadObject, EC_T_CPUSET CpuSet );
EC_T_BOOL   OsGetThreadAffinity( EC_T_VOID* pvThreadObject, EC_T_CPUSET* pCpuSet );

ATECAT_API EC_PF_LLREGISTER OsGetLinkLayerRegFunc( EC_T_CHAR* szDriverIdent );
ATECAT_API EC_T_DWORD  OsSystemTimeGet(EC_T_UINT64* pqwSystemTime);

#ifndef OsMemoryBarrier
EC_T_VOID   OsMemoryBarrier(EC_T_VOID);
#endif

ATECAT_API EC_PF_OSDBGMSGHK OsGetDbgMsgHook();

#ifndef OsForceThreadPrioNormal
ATECAT_API EC_T_DWORD OsForceThreadPrioNormal(EC_T_VOID);
#endif

#ifdef __cplusplus
} /* extern "C"*/
#endif

/*-PACK SETTINGS-------------------------------------------------------------*/
#if defined  __GNUC__   /* GNU */

#undef  EC_PACKED

#if (defined __RCX__)
#pragma pack ()
#endif

#elif defined _MSC_VER  /* MICROSOFT */

#undef  EC_PACKED
#pragma pack (pop)

#elif defined __MET__

#undef EC_PACKED
/*#pragma pack (pop)*/
#pragma Pop_align_members()

#else
#endif

#endif /* INC_ECOS */


/*-END OF SOURCE FILE--------------------------------------------------------*/
